/**
 * OWASP AppSensor
 * 
 * This file is part of the Open Web Application Security Project (OWASP)
 * AppSensor project. For details, please see
 * <a href="http://www.owasp.org/index.php/Category:OWASP_AppSensor_Project">
 * 	http://www.owasp.org/index.php/Category:OWASP_AppSensor_Project</a>.
 *
 * Copyright (c) 2010 - The OWASP Foundation
 * 
 * AppSensor is published by OWASP under the BSD license. You should read and accept the
 * LICENSE before you use, modify, and/or redistribute this software.
 * 
 * @author Michael Coates <a href="http://www.aspectsecurity.com">Aspect Security</a>
 * @author John Melton <a href="http://www.jtmelton.com/">jtmelton</a>
 * @created 2010
 */
namespace org.owasp.appsensor
{
    using System;
    /**
     * This interface specifies the requirements for a logger that is used in
     * AppSensor.  It is likely that there will be one or more default implementations
     * that will be commonly used by users of the system.  One of the default 
     * implementations will use the Esapi logger, which also uses other logging
     * systems itself, but which adds additional features such as security "tags"
     * to the log as well as log encoding.  
     * 
     * @author Michael Coates (michael.coates .at. owasp.org) 
     *         <a href="http://www.aspectsecurity.com">Aspect Security</a>
     * @author John Melton (jtmelton .at. gmail.com)
     *         <a href="http://www.jtmelton.com/">jtmelton</a>
     * @since May 6, 2010
     *
     */
    public interface ASLogger
    {

        /**
         * Log a fatal event
         * 
         * @param message 
         * 		the message to log
         */
        void Fatal(String message);

        /**
         * Log a fatal level security event
         * and also record the stack trace associated with the event.
         * 
         * @param message 
         * 		the message to log
         * @param throwable 
         * 		the exception to be logged
         */
        void Fatal(String message, Exception throwable);

        /**
         * Log an error level security event
         * 
         * @param message 
         * 		the message to log
         */
        void Error(String message);

        /**
         * Log an error level security event
         * and also record the stack trace associated with the event.
         * 
         * @param message 
         * 		the message to log
         * @param throwable 
         * 		the exception to be logged
         */
        void Error(String message, Exception throwable);

        /**
         * Log a warning level security event
         * 
         * @param message 
         * 		the message to log
         */
        void Warning(String message);

        /**
         * Log a warning level security event
         * and also record the stack trace associated with the event.
         * 
         * @param message 
         * 		the message to log
         * @param throwable 
         * 		the exception to be logged
         */
        void Warning(String message, Exception throwable);

        /**
         * Log an info level security event
         * 
         * @param message 
         * 		the message to log
         */
        void Info(String message);

        /**
         * Log an info level security event
         * and also record the stack trace associated with the event.
         * 
         * @param message 
         * 		the message to log
         * @param throwable 
         * 		the exception to be logged
         */
        void Info(String message, Exception throwable);

        /**
         * Log a debug level security event
         * 
         * @param message 
         * 		the message to log
         */
        void Debug(String message);

        /**
         * Log a debug level security event
         * and also record the stack trace associated with the event.
         * 
         * @param message 
         * 		the message to log
         * @param throwable 
         * 		the exception to be logged
         */
        void Debug(String message, Exception throwable);
    }
}